

const langButtons = document.querySelectorAll('.language-toggle button');
const agbColumns = document.querySelectorAll('.agb-column');

langButtons.forEach(btn => {
    btn.addEventListener('click', () => {
        langButtons.forEach(b => b.classList.remove('active'));
        btn.classList.add('active');
        const lang = btn.getAttribute('data-lang');
        agbColumns.forEach(col => {
            if(col.classList.contains(lang)) col.classList.add('active');
            else col.classList.remove('active');
        });
    });
});


// end











// menu but

document.addEventListener('DOMContentLoaded', () => {
    const menuToggle = document.querySelector('.menu-toggle');
    const navLinks = document.querySelector('.nav-links');

    if(menuToggle && navLinks){
        // فتح / غلق القائمة عند الضغط على الزر
        menuToggle.addEventListener('click', (e) => {
            navLinks.classList.toggle('active');
            e.stopPropagation(); // منع انتقال الحدث للـ document
        });

        // إغلاق القائمة عند الضغط خارجها
        document.addEventListener('click', (e) => {
            if(navLinks.classList.contains('active') && !navLinks.contains(e.target) && !menuToggle.contains(e.target)) {
                navLinks.classList.remove('active');
            }
        });
    }
});



// end








// close banner
document.addEventListener("DOMContentLoaded", function() {
  const banner = document.getElementById("eligibility-banner");
  const acceptBtn = document.querySelector(".eligibility-accept");
  const closeBtn = document.querySelector(".eligibility-close");

  function hideBanner() {
    banner.style.transition = "opacity 0.5s ease, transform 0.5s ease";
    banner.style.opacity = "0";
    banner.style.transform = "translateY(100%)";
    setTimeout(() => banner.remove(), 500);
  }

  acceptBtn.addEventListener("click", hideBanner);
  closeBtn.addEventListener("click", hideBanner);
});





// end











// js how it woirks 

  
document.addEventListener('DOMContentLoaded', function () {
  // نأخذ كل الأقسام اللي عندها الصنف how-it-works
  const sections = Array.from(document.querySelectorAll('section.how-it-works'));
  const toggle = document.getElementById('hfc-toggle');
  if(!toggle) return; // لو الأزرار مش موجودة، نخرج
  const buttons = Array.from(toggle.querySelectorAll('.hfc-tab-btn'));

  // safety: نحتاج على الأقل قسمين
  if (sections.length < 2) {
    console.warn('HFC Toggle: مطلوب على الأقل 2 section.how-it-works. تم العثور على:', sections.length);
    return;
  }

  // دالة لعرض قسم حسب الفهرس (index)
  function showIndex(i) {
    sections.forEach((sec, idx) => {
      // نحافظ على كل العناصر داخل القسم كما هي، بس نخفي/نُظهر القسم نفسه
      sec.style.display = (idx === i ? '' : 'none'); // '' يسمح بالرجوع لستايل الـ CSS الأصلي
    });

    buttons.forEach((btn, idx) => {
      btn.classList.toggle('active', idx === i);
      btn.setAttribute('aria-pressed', idx === i ? 'true' : 'false');
    });

    // لو بتستخدم AOS للأنيميشن، نعمل refresh علشان يظهر العنصر الجديد بشكل صحيح
    if (window.AOS && typeof window.AOS.refresh === 'function') {
      // نأجل شويه حتى يتنفذ DOM render
      setTimeout(()=> window.AOS.refresh(), 60);
    }
  }

  // ربط الأزرار
  buttons.forEach(btn => {
    btn.addEventListener('click', function () {
      const idx = parseInt(this.dataset.index, 10);
      if (!isNaN(idx)) showIndex(idx);
    });
  });

  // تهيئة العرض - نعرض الأول افتراضياً (index 0)
  showIndex(0);
});



// end







AOS.init();









