<?php
// ملف: login.php

// ابدأ الجلسة
session_start();

// كلمة المرور المشفرة (لا تقم بتعديلها يدوياً)
// هذه القيمة المشفرة لكلمة المرور: 88888888
$hashedPassword = '88888888';

$errorMessage = '';

// التحقق مما إذا تم إرسال النموذج (Form)
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $inputPassword = $_POST['password'];

    // التحقق من كلمة المرور المدخلة مقابل القيمة المشفرة
    if (password_verify($inputPassword, $hashedPassword)) {
        // كلمة المرور صحيحة، قم بتسجيل الدخول
        $_SESSION['is_logged_in'] = true;
        
        // أعد توجيه المستخدم إلى الصفحة المحمية
        header('Location: admin_unknown.php');
        exit;
    } else {
        // كلمة المرور خاطئة
        $errorMessage = 'كلمة المرور غير صحيحة. حاول مرة أخرى.';
    }
}
?>

<!DOCTYPE html>
<html>
<head>
    <title>تسجيل الدخول</title>
    <meta charset="UTF-8">
</head>
<body>
    <h1>تسجيل الدخول إلى لوحة التحكم</h1>
    <?php if (!empty($errorMessage)): ?>
        <p style="color: red;"><?php echo $errorMessage; ?></p>
    <?php endif; ?>
    <form action="login.php" method="post">
        <label for="password">كلمة المرور:</label><br>
        <input type="password" id="password" name="password" required><br><br>
        <input type="submit" value="دخول">
    </form>
</body>
</html>