<?php
if(!isset($_POST['index']) || !isset($_POST['reply'])) exit('Invalid request');

$index = intval($_POST['index']);
$reply = trim($_POST['reply']);

$unknown_file = 'unknown_messages.json';
$data_file = 'data.json';

$unknown_messages = file_exists($unknown_file) ? json_decode(file_get_contents($unknown_file), true) : [];
$data = file_exists($data_file) ? json_decode(file_get_contents($data_file), true) : [];

if(!isset($unknown_messages[$index])) exit('Message not found');

$new_entry = [
    'keyword' => $unknown_messages[$index],
    'aliases' => [],
    'response' => $reply,
    'context' => 'manual' // mark as manually added
];

$data[] = $new_entry;
file_put_contents($data_file, json_encode($data, JSON_PRETTY_PRINT));

// Remove from unknown
array_splice($unknown_messages,$index,1);
file_put_contents($unknown_file, json_encode($unknown_messages, JSON_PRETTY_PRINT));

echo "Reply saved successfully.";
