<?php
session_start(); // جلسة لتسجيل الدخول

// --- كلمة المرور ---
$PASSWORD = "12345"; // ضع هنا كلمة المرور التي تريدها

// --- زر الخروج ---
if (isset($_GET['logout'])) {
    session_destroy();
    header("Location: ".$_SERVER['PHP_SELF']);
    exit;
}

// --- التحقق من تسجيل الدخول ---
if (!isset($_SESSION['authenticated']) || $_SESSION['authenticated'] !== true) {
    $error = '';
    if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['password'])) {
        if ($_POST['password'] === $PASSWORD) {
            $_SESSION['authenticated'] = true;
            header("Location: ".$_SERVER['PHP_SELF']);
            exit;
        } else {
            $error = "كلمة المرور خاطئة!";
        }
    }
    // --- فورم تسجيل الدخول الجذاب ---
    ?>
    <!DOCTYPE html>
    <html lang="ar">
    <head>
        <meta charset="UTF-8">
        <title>تسجيل الدخول</title>
        <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
        <style>
            body { font-family: Arial,sans-serif; background: linear-gradient(135deg,#667eea,#764ba2); display:flex; justify-content:center; align-items:center; height:100vh; margin:0; }
            form { background:#fff; padding:40px; border-radius:12px; box-shadow:0 10px 25px rgba(0,0,0,0.3); width:320px; text-align:center; }
            h2 { margin-bottom:20px; color:#333; }
            input { width:100%; padding:12px; margin-bottom:15px; border:1px solid #ccc; border-radius:6px; font-size:16px; }
            button { width:100%; padding:12px; border:none; border-radius:6px; background:#764ba2; color:#fff; font-size:16px; cursor:pointer; transition:0.3s; }
            button:hover { background:#667eea; }
            p.error { color:red; margin-bottom:15px; }
            .fa-lock { color:#764ba2; margin-bottom:10px; font-size:28px; }
        </style>
    </head>
    <body>
        <form method="POST">
            <i class="fas fa-lock"></i>
            <h2>تسجيل الدخول</h2>
            <?php if($error) echo "<p class='error'>$error</p>"; ?>
            <input type="password" name="password" placeholder="كلمة المرور" required>
            <button type="submit">دخول</button>
        </form>
    </body>
    </html>
    <?php
    exit;
}

// ---------------------------
// الكود الأصلي بالكامل كما هو
// ---------------------------
$unknownFile = 'unknown_messages.json';
$dataFile = 'data.json';
$lang = $_GET['lang'] ?? 'ar';

// --- ترجمة ---
$labels = [
    'ar'=>[
        'panel_title'=>'لوحة تحكم الرسائل',
        'unknown_messages'=>'الرسائل غير المفهومة',
        'no_unknown'=>'لا توجد رسائل غير مفهومة.',
        'existing_messages'=>'الرسائل الموجودة (data.json)',
        'no_data'=>'لا توجد رسائل في data.json.',
        'keyword'=>'الكلمة المفتاحية',
        'aliases'=>'المرادفات',
        'response'=>'الرد',
        'context'=>'السياق',
        'suggestions'=>'الاقتراحات',
        'source_url'=>'رابط المصدر',
        'timestamp'=>'الوقت',
        'save'=>'حفظ',
        'update'=>'تحديث',
        'delete'=>'حذف',
        'switch_lang'=>'English'
    ],
    'en'=>[
        'panel_title'=>'Messages Admin Panel',
        'unknown_messages'=>'Unknown Messages',
        'no_unknown'=>'No unknown messages.',
        'existing_messages'=>'Existing Messages (data.json)',
        'no_data'=>'No messages in data.json.',
        'keyword'=>'Keyword',
        'aliases'=>'Aliases',
        'response'=>'Response',
        'context'=>'Context',
        'suggestions'=>'Suggestions',
        'source_url'=>'Source URL',
        'timestamp'=>'Timestamp',
        'save'=>'Save',
        'update'=>'Update',
        'delete'=>'Delete',
        'switch_lang'=>'العربية'
    ]
];

// --- معالجة POST ---
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $action = $_POST['action'] ?? '';
    $index = intval($_POST['index'] ?? -1);
    $source = $_POST['source'] ?? '';

    if ($source === 'unknown') {
        $unknown = file_exists($unknownFile) ? json_decode(file_get_contents($unknownFile), true) : [];
        if(!isset($unknown[$index])) { header("Location: ".$_SERVER['PHP_SELF']); exit; }

        if($action==='save'){
            $keyword = trim($_POST['keyword'] ?? '');
            $response = trim($_POST['response'] ?? '');
            $aliases = array_filter(array_map('trim', explode(',', $_POST['aliases'] ?? '')));
            $context = trim($_POST['context'] ?? 'unknown');
            $suggestions = array_filter(array_map('trim', explode(',', $_POST['suggestions'] ?? '')));
            $source_url = trim($_POST['source_url'] ?? '');

            $msgItem = $unknown[$index];
            $data = file_exists($dataFile) ? json_decode(file_get_contents($dataFile), true) : [];

            $newItem = [
                'keyword' => $keyword ?: (is_array($msgItem) ? ($msgItem['message'] ?? json_encode($msgItem)) : $msgItem),
                'response' => is_array($response) ? $response : [$response],
                'aliases' => $aliases,
                'context' => $context,
                'suggestions' => $suggestions,
                'source_url' => $source_url
            ];
            $data[] = $newItem;
            file_put_contents($dataFile, json_encode($data, JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE));

            array_splice($unknown, $index, 1);
            file_put_contents($unknownFile, json_encode($unknown, JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE));
        }

        if($action==='delete'){
            array_splice($unknown, $index, 1);
            file_put_contents($unknownFile, json_encode($unknown, JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE));
        }

    } elseif($source==='data'){
        $data = file_exists($dataFile) ? json_decode(file_get_contents($dataFile), true) : [];
        if(!isset($data[$index])) { header("Location: ".$_SERVER['PHP_SELF']); exit; }

        if($action==='update'){
            $data[$index]['keyword'] = $_POST['keyword'] ?? $data[$index]['keyword'];
            $resp = $_POST['response'] ?? $data[$index]['response'];
            $data[$index]['response'] = is_array($resp) ? $resp : [$resp];
            $aliases = $_POST['aliases'] ?? '';
            $data[$index]['aliases'] = array_filter(array_map('trim', explode(',', $aliases)));
            $suggestions = $_POST['suggestions'] ?? '';
            $data[$index]['suggestions'] = array_filter(array_map('trim', explode(',', $suggestions)));
            $data[$index]['context'] = $_POST['context'] ?? $data[$index]['context'];
            $data[$index]['source_url'] = $_POST['source_url'] ?? $data[$index]['source_url'];
            file_put_contents($dataFile, json_encode($data, JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE));
        }

        if($action==='delete'){
            array_splice($data, $index, 1);
            file_put_contents($dataFile, json_encode($data, JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE));
        }
    }

    header("Location: ".$_SERVER['PHP_SELF']."?lang=$lang"); exit;
}

// --- قراءة الملفات ---
$unknown = file_exists($unknownFile) ? json_decode(file_get_contents($unknownFile), true) : [];
$data = file_exists($dataFile) ? json_decode(file_get_contents($dataFile), true) : [];
$l = $labels[$lang];
?>
<!DOCTYPE html>
<html lang="<?php echo $lang; ?>">
<head>
<meta charset="UTF-8">
<title><?php echo $l['panel_title']; ?></title>
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
<style>
body { font-family: Arial,sans-serif; background:#f0f2f5; padding:20px; direction: rtl; }
h1,h2{text-align:center;color:#fff;background:linear-gradient(66deg,#3f5efb 0%,#fc466b 100%);padding:10px;border-radius:8px;}
table { width:100%; border-collapse:collapse; margin-bottom:30px; background:#fff; box-shadow:0 4px 10px rgba(0,0,0,0.15); border-radius:8px; overflow:hidden;}
th,td { padding:10px; text-align:right; border-bottom:1px solid #ddd; vertical-align:top;}
th { background:linear-gradient(66deg,#3f5efb 0%,#fc466b 100%); color:#fff;}
input[type=text], textarea { width:95%; padding:5px; margin-bottom:5px; border:1px solid #ccc; border-radius:4px; }
textarea { resize: vertical; }
button { padding:5px 10px; cursor:pointer; margin:2px; border:none; border-radius:4px; font-weight:bold;}
button.save{background:#3f5efb;color:#fff;}
button.update{background:#fc466b;color:#fff;}
button.delete{background:red;color:#fff;}
form {margin:0;}
.lang-switch{position:fixed;top:10px;left:10px;padding:5px 10px;background:#3f5efb;color:#fff;text-decoration:none;border-radius:4px;}
i.fas{margin-right:5px;}
.logout-btn {position:fixed;top:15px;right:15px;padding:8px 12px;background:red;color:#fff;border-radius:6px;text-decoration:none;font-weight:bold;}
</style>
</head>
<body>
<a class="lang-switch" href="?lang=<?php echo $lang==='ar'?'en':'ar'; ?>"><?php echo $l['switch_lang']; ?></a>
<a class="logout-btn" href="?logout=1">تسجيل الخروج</a>
<h1><?php echo $l['panel_title']; ?></h1>

<h2><?php echo $l['unknown_messages']; ?></h2>
<?php if(empty($unknown)): ?>
<p style="text-align:center;"><?php echo $l['no_unknown']; ?></p>
<?php else: ?>
<table>
<tr>
<th>#</th><th>Message</th><th><?php echo $l['keyword'];?></th><th><?php echo $l['aliases'];?></th><th><?php echo $l['response'];?></th><th><?php echo $l['context'];?></th><th><?php echo $l['suggestions'];?></th><th><?php echo $l['source_url'];?></th><th><?php echo $l['timestamp'];?></th><th><?php echo $l['save'];?></th><th><?php echo $l['delete'];?></th>
</tr>
<?php foreach($unknown as $i=>$item):
$msgText = is_array($item)?($item['message']??json_encode($item)):$item;
$ts = is_array($item)?($item['timestamp']??''):''; ?>
<tr>
<td><?php echo $i+1;?></td>
<td><?php echo htmlspecialchars($msgText);?></td>
<form method="post">
<td><input type="text" name="keyword" placeholder="<?php echo $l['keyword'];?>"></td>
<td><input type="text" name="aliases" placeholder="<?php echo $l['aliases'];?>"></td>
<td><textarea name="response" placeholder="<?php echo $l['response'];?>" rows="2"></textarea></td>
<td><input type="text" name="context" placeholder="<?php echo $l['context'];?>"></td>
<td><input type="text" name="suggestions" placeholder="<?php echo $l['suggestions'];?>"></td>
<td><input type="text" name="source_url" placeholder="<?php echo $l['source_url'];?>"></td>
<td><?php echo htmlspecialchars($ts);?></td>
<td>
<input type="hidden" name="index" value="<?php echo $i;?>">
<input type="hidden" name="action" value="save">
<input type="hidden" name="source" value="unknown">
<button type="submit" class="save"><i class="fas fa-save"></i> <?php echo $l['save'];?></button>
</td>
</form>
<td>
<form method="post">
<input type="hidden" name="index" value="<?php echo $i;?>">
<input type="hidden" name="action" value="delete">
<input type="hidden" name="source" value="unknown">
<button type="submit" class="delete"><i class="fas fa-trash"></i> <?php echo $l['delete'];?></button>
</form>
</td>
</tr>
<?php endforeach;?>
</table>
<?php endif; ?>

<h2><?php echo $l['existing_messages'];?></h2>
<?php if(empty($data)): ?>
<p style="text-align:center;"><?php echo $l['no_data']; ?></p>
<?php else: ?>
<table>
<tr>
<th>#</th><th><?php echo $l['keyword'];?></th><th><?php echo $l['aliases'];?></th><th><?php echo $l['response'];?></th><th><?php echo $l['context'];?></th><th><?php echo $l['suggestions'];?></th><th><?php echo $l['source_url'];?></th><th>Actions</th>
</tr>
<?php foreach($data as $i=>$item):
$aliasesText = implode(', ', is_array($item['aliases'])?$item['aliases']:[]);
$responseText = implode("\n", is_array($item['response'])?$item['response']:[$item['response']??'']);
$suggestionsText = implode(', ', is_array($item['suggestions'])?$item['suggestions']:[]); ?>
<tr>
<form method="post">
<td><?php echo $i+1;?></td>
<td><input type="text" name="keyword" value="<?php echo htmlspecialchars($item['keyword']);?>"></td>
<td><input type="text" name="aliases" value="<?php echo htmlspecialchars($aliasesText);?>"></td>
<td><textarea name="response" rows="2"><?php echo htmlspecialchars($responseText);?></textarea></td>
<td><input type="text" name="context" value="<?php echo htmlspecialchars($item['context']);?>"></td>
<td><input type="text" name="suggestions" value="<?php echo htmlspecialchars($suggestionsText);?>"></td>
<td><input type="text" name="source_url" value="<?php echo htmlspecialchars($item['source_url']);?>"></td>
<td>
<input type="hidden" name="index" value="<?php echo $i;?>">
<input type="hidden" name="action" value="update">
<input type="hidden" name="source" value="data">
<button type="submit" class="update"><i class="fas fa-edit"></i> <?php echo $l['update'];?></button>
</td>
</form>
<td>
<form method="post">
<input type="hidden" name="index" value="<?php echo $i;?>">
<input type="hidden" name="action" value="delete">
<input type="hidden" name="source" value="data">
<button type="submit" class="delete"><i class="fas fa-trash"></i> <?php echo $l['delete'];?></button>
</form>
</td>
</tr>
<?php endforeach;?>
</table>
<?php endif;?>

</body>
</html>
